﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text;

namespace ApplicationServicesDemo
{
    public partial class OrderEntry : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (User.IsInRole("Managers"))
            {
                DropDownListDiscount.Enabled = true;
                LinkButtonManagerEnable.Visible = false;
            }
            else
            {
                DropDownListDiscount.Enabled = false;
                SetSecurityMessage();
            }
        }

        private void SetSecurityMessage()
        {
            string[] roles = Roles.GetRolesForUser();
            StringBuilder securityMessage = new StringBuilder();
            securityMessage.Append("Nie należysz do roli Managers, zatem Twoje możliwości korzystania z tej strony są ograniczone. ");
            securityMessage.Append("Obecnie należysz do następujących ról: ");
            int roleCount = roles.Length;
            if (roleCount == 0)
            {
                securityMessage.Append("Brak");
            }
            else
            {
                foreach (string role in roles)
                {
                    securityMessage.Append(role);
                    if (--roleCount != 0)
                    {
                        securityMessage.Append(", ");
                    }
                }
            }

            LabelSecurityMessage.Text = securityMessage.ToString();
        }
    }
}
